/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.IMySignature;
import anon.crypto.MyDSASignature;
import anon.crypto.MyECPrivateKey;
import anon.crypto.MyECPublicKey;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.signers.ECDSASigner;

public final class MyECDSASignature
implements IMySignature {
    private static final AlgorithmIdentifier ms_identifier = new AlgorithmIdentifier(X9ObjectIdentifiers.ecdsa_with_SHA1);
    SHA1Digest m_digest = new SHA1Digest();
    ECDSASigner m_signatureAlgorithm = new ECDSASigner();
    private Key m_initKey;

    public byte[] encodeForXMLSignature(byte[] byArray) {
        int n = ((MyECPrivateKey)this.m_initKey).getPrivateParams().getParameters().getN().toByteArray().length;
        byte by = byArray[3];
        byte by2 = byArray[3 + by + 2];
        byte[] byArray2 = new byte[2 * n];
        for (int i = 0; i < 2 * n; ++i) {
            byArray2[i] = 0;
        }
        System.arraycopy(byArray, 4, byArray2, n - by, by);
        System.arraycopy(byArray, 4 + by + 2, byArray2, 2 * n - by2, by2);
        return byArray2;
    }

    public byte[] decodeForXMLSignature(byte[] byArray) {
        byte[] byArray2;
        int n = ((MyECPublicKey)this.m_initKey).getPublicParams().getParameters().getN().toByteArray().length;
        if (byArray.length != 2 * n) {
            return null;
        }
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray, n, byArray4, 0, n);
        try {
            byArray2 = MyDSASignature.derEncode(new BigInteger(byArray3), new BigInteger(byArray4));
        }
        catch (IOException iOException) {
            byArray2 = null;
        }
        return byArray2;
    }

    public String getXMLSignatureAlgorithmReference() {
        return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
    }

    public synchronized void initSign(IMyPrivateKey iMyPrivateKey) throws InvalidKeyException {
        try {
            MyECPrivateKey myECPrivateKey = (MyECPrivateKey)iMyPrivateKey;
            this.m_signatureAlgorithm.init(true, myECPrivateKey.getPrivateParams());
            this.m_initKey = iMyPrivateKey;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("MyECDSASignautre - initVerify - dont know how to handle the given key");
        }
    }

    public synchronized void initVerify(IMyPublicKey iMyPublicKey) throws InvalidKeyException {
        try {
            MyECPublicKey myECPublicKey = (MyECPublicKey)iMyPublicKey;
            this.m_signatureAlgorithm.init(false, myECPublicKey.getPublicParams());
            this.m_digest.reset();
            this.m_initKey = iMyPublicKey;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("MyECDSASignautre - initVerify - dont know how to handle the given key");
        }
    }

    public synchronized byte[] sign(byte[] byArray) {
        try {
            this.m_digest.reset();
            this.m_digest.update(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[this.m_digest.getDigestSize()];
            this.m_digest.doFinal(byArray2, 0);
            BigInteger[] bigIntegerArray = this.m_signatureAlgorithm.generateSignature(byArray2);
            return MyDSASignature.derEncode(bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public synchronized boolean verify(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        try {
            this.m_digest.reset();
            this.m_digest.update(byArray, n, n2);
            byte[] byArray3 = new byte[this.m_digest.getDigestSize()];
            this.m_digest.doFinal(byArray3, 0);
            BigInteger[] bigIntegerArray = MyDSASignature.derDecode(byArray2, n3, n4);
            return this.m_signatureAlgorithm.verifySignature(byArray3, bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (Throwable throwable) {
            LogHolder.log(7, LogType.CRYPTO, "Signature algorithm does not match!");
            return false;
        }
    }

    public synchronized boolean verify(byte[] byArray, byte[] byArray2) {
        return this.verify(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public AlgorithmIdentifier getIdentifier() {
        return ms_identifier;
    }
}

