/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;
import javax.swing.text.JTextComponent;

public class MetalBorders {

    public static class Flush3DBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component.isEnabled()) {
                MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
            } else {
                MetalUtils.drawDisabledBorder(graphics, n, n2, n3, n4);
            }
        }
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 3, 3, 3);

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    MetalUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
                } else if (jButton.isDefaultButton()) {
                    jButton.hasFocus();
                    MetalUtils.drawDefaultButtonBorder(graphics, n, n2, n3, n4, false);
                } else {
                    jButton.hasFocus();
                    MetalUtils.drawButtonBorder(graphics, n, n2, n3, n4, false);
                }
            } else {
                MetalUtils.drawDisabledBorder(graphics, n, n2, n3 - 1, n4 - 1);
            }
        }
    }

    public static class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(5, 5, 5, 5);
        private static final int corner = 14;

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource;
            ColorUIResource colorUIResource2;
            ColorUIResource colorUIResource3;
            if (component instanceof JInternalFrame && ((JInternalFrame)component).isSelected()) {
                colorUIResource3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
                colorUIResource2 = MetalLookAndFeel.getPrimaryControlShadow();
                colorUIResource = MetalLookAndFeel.getPrimaryControlInfo();
            } else {
                colorUIResource3 = MetalLookAndFeel.getControlDarkShadow();
                colorUIResource2 = MetalLookAndFeel.getControlShadow();
                colorUIResource = MetalLookAndFeel.getControlInfo();
            }
            graphics.setColor(colorUIResource3);
            graphics.drawLine(1, 0, n3 - 2, 0);
            graphics.drawLine(0, 1, 0, n4 - 2);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 2);
            graphics.drawLine(1, n4 - 1, n3 - 2, n4 - 1);
            int n5 = 1;
            while (n5 < 5) {
                graphics.drawRect(n + n5, n2 + n5, n3 - n5 * 2 - 1, n4 - n5 * 2 - 1);
                ++n5;
            }
            graphics.setColor(colorUIResource2);
            graphics.drawLine(15, 3, n3 - 14, 3);
            graphics.drawLine(3, 15, 3, n4 - 14);
            graphics.drawLine(n3 - 2, 15, n3 - 2, n4 - 14);
            graphics.drawLine(15, n4 - 2, n3 - 14, n4 - 2);
            graphics.setColor(colorUIResource);
            graphics.drawLine(14, 2, n3 - 14 - 1, 2);
            graphics.drawLine(2, 14, 2, n4 - 14 - 1);
            graphics.drawLine(n3 - 3, 14, n3 - 3, n4 - 14 - 1);
            graphics.drawLine(14, n4 - 3, n3 - 14 - 1, n4 - 3);
        }
    }

    static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);
        int titleHeight = 0;

        PaletteBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(0, 1, 0, n4 - 2);
            graphics.drawLine(1, n4 - 1, n3 - 2, n4 - 1);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 2);
            graphics.drawLine(1, 0, n3 - 2, 0);
            graphics.drawRect(1, 1, n3 - 3, n4 - 3);
            graphics.translate(-n, -n2);
        }
    }

    public static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(1, 0, 1, 0);

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(0, n4 - 1, n3, n4 - 1);
            graphics.translate(-n, -n2);
        }
    }

    public static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(2, 2, 2, 2);

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            graphics.translate(n, n2);
            if (component.getParent() instanceof JMenuBar) {
                if (buttonModel.isArmed() || buttonModel.isSelected()) {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(0, 0, n3 - 2, 0);
                    graphics.drawLine(0, 0, 0, n4 - 1);
                    graphics.drawLine(n3 - 2, 2, n3 - 2, n4 - 1);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                    graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
                    graphics.setColor(MetalLookAndFeel.getMenuBackground());
                    graphics.drawLine(n3 - 1, 0, n3 - 1, 0);
                }
            } else if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                graphics.drawLine(0, 0, n3 - 1, 0);
                graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            } else {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                graphics.drawLine(0, 0, 0, n4 - 1);
            }
            graphics.translate(-n, -n2);
        }
    }

    public static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 1, 2, 1);

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(1, 1, n3 - 2, 1);
            graphics.drawLine(1, 2, 1, 2);
            graphics.drawLine(1, n4 - 2, 1, n4 - 2);
            graphics.translate(-n, -n2);
        }
    }

    public static class RolloverButtonBorder
    extends ButtonBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isRollover() && (!buttonModel.isPressed() || buttonModel.isArmed())) {
                super.paintBorder(component, graphics, n, n2, n3, n4);
            }
        }
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        protected MetalBumps bumps = new MetalBumps(10, 10, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getMenuBackground());

        public Insets getBorderInsets(Component component) {
            Insets insets;
            Insets insets2 = new Insets(2, 2, 2, 2);
            if (((JToolBar)component).isFloatable()) {
                if (((JToolBar)component).getOrientation() == 0) {
                    insets2.left = 16;
                } else {
                    insets2.top = 16;
                }
            }
            if ((insets = ((JToolBar)component).getMargin()) != null) {
                insets2.left += insets.left;
                insets2.top += insets.top;
                insets2.right += insets.right;
                insets2.bottom += insets.bottom;
            }
            return insets2;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            if (((JToolBar)component).isFloatable()) {
                if (((JToolBar)component).getOrientation() == 0) {
                    this.bumps.setBumpArea(10, component.getSize().height - 4);
                    if (MetalUtils.isLeftToRight(component)) {
                        this.bumps.paintIcon(component, graphics, 2, 2);
                    } else {
                        this.bumps.paintIcon(component, graphics, component.getBounds().width - 12, 2);
                    }
                } else {
                    this.bumps.setBumpArea(component.getSize().width - 4, 10);
                    this.bumps.paintIcon(component, graphics, 2, 2);
                }
            }
            graphics.translate(-n, -n2);
        }
    }

    public static class TextFieldBorder
    extends Flush3DBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(component instanceof JTextComponent)) {
                if (component.isEnabled()) {
                    MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
                } else {
                    MetalUtils.drawDisabledBorder(graphics, n, n2, n3, n4);
                }
                return;
            }
            if (component.isEnabled() && ((JTextComponent)component).isEditable()) {
                MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
            } else {
                MetalUtils.drawDisabledBorder(graphics, n, n2, n3, n4);
            }
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 2, 2);

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JScrollPane jScrollPane = (JScrollPane)component;
            JViewport jViewport = jScrollPane.getColumnHeader();
            int n5 = 0;
            if (jViewport != null) {
                n5 = jViewport.getHeight();
            }
            JViewport jViewport2 = jScrollPane.getRowHeader();
            int n6 = 0;
            if (jViewport2 != null) {
                n6 = jViewport2.getWidth();
            }
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
            graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(n3 - 2, 2 + n5, n3 - 2, 2 + n5);
            graphics.drawLine(1 + n6, n4 - 2, 1 + n6, n4 - 2);
            graphics.translate(-n, -n2);
        }
    }

    static class ToggleButtonBorder
    extends ButtonBorder {
        ToggleButtonBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JToggleButton jToggleButton = (JToggleButton)component;
            ButtonModel buttonModel = jToggleButton.getModel();
            if (!component.isEnabled()) {
                MetalUtils.drawDisabledBorder(graphics, n, n2, n3, n4);
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                MetalUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
            } else if (buttonModel.isSelected()) {
                MetalUtils.drawDark3DBorder(graphics, n, n2, n3, n4);
            } else {
                MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
            }
        }
    }
}

