/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.plaf.mac.MacFileChooserUI;
import com.sun.java.swing.plaf.mac.MacFileSystemView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class MacFileChooserUI
extends BasicFileChooserUI {
    private JFileChooser filechooser;
    private JComboBox comboBox;
    private DefaultComboBoxModel comboBoxModel;
    private JLabel volumeLabel;
    private JList list;
    private JButton ejectButton;
    private JButton desktopButton;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel leftPanel;
    private JTextField editField;
    private JPanel editPanel;
    private FileSystemView oldFileSystemView;
    private boolean isTemporary = false;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField filenameTextField;
    private static int PREF_WIDTH = 356;
    private static int PREF_HEIGHT = 178;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 356;
    private static int MIN_HEIGHT = 178;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_MIN_WIDTH = 400;
    private static int LIST_MIN_HEIGHT = 100;
    private static Dimension LIST_MIN_SIZE = new Dimension(LIST_MIN_WIDTH, LIST_MIN_HEIGHT);
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;

    public MacFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
        this.filechooser = jFileChooser;
    }

    void addEditField() {
        this.leftPanel.add("South", this.editField);
    }

    void buildParents(File file) {
        this.comboBoxModel.addElement(file);
        if (file.getParent() != null && !file.getParent().equals("/")) {
            this.buildParents(new File(file.getParent()));
        } else {
            this.volumeLabel.setText(file.toString());
        }
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.list = new JList();
        this.list.setCellRenderer(new FileRenderer());
        this.list.setModel(this.getModel());
        this.list.addListSelectionListener(this.createListSelectionListener(jFileChooser));
        this.list.addMouseListener(this.createDoubleClickListener(jFileChooser, this.list));
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    File file = (File)propertyChangeEvent.getNewValue();
                    if (file != null) {
                        MacFileChooserUI.this.setFileName(MacFileChooserUI.this.getFileChooser().getName(file));
                        if (MacFileChooserUI.this.getModel().contains(file)) {
                            MacFileChooserUI.this.list.setSelectedIndex(MacFileChooserUI.this.getModel().indexOf(propertyChangeEvent.getNewValue()));
                            MacFileChooserUI.this.list.ensureIndexIsVisible(MacFileChooserUI.this.list.getSelectedIndex());
                        }
                    }
                } else if (string.equals("DialogTypeChangedProperty")) {
                    int n = (Integer)propertyChangeEvent.getOldValue();
                    int n2 = (Integer)propertyChangeEvent.getNewValue();
                    if (n2 == 0) {
                        MacFileChooserUI.this.removeEditField();
                    } else if (n == 0) {
                        MacFileChooserUI.this.addEditField();
                    }
                } else if (string.equals("directoryChanged")) {
                    MacFileChooserUI.this.clearIconCache();
                    MacFileChooserUI.this.list.clearSelection();
                    MacFileChooserUI.this.initializeComboBox();
                } else if (string.equals("fileSelectionChanged")) {
                    MacFileChooserUI.this.clearIconCache();
                    MacFileChooserUI.this.list.clearSelection();
                } else if (string == "AccessoryChangedProperty") {
                    if (MacFileChooserUI.this.getAccessoryPanel() != null) {
                        JComponent jComponent;
                        if (propertyChangeEvent.getOldValue() != null) {
                            MacFileChooserUI.this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
                        }
                        if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                            MacFileChooserUI.this.getAccessoryPanel().add((Component)jComponent, "Center");
                        }
                    }
                } else if (string == "ApproveButtonTextChangedProperty" || string == "DialogTypeChangedProperty") {
                    JFileChooser jFileChooser = MacFileChooserUI.this.getFileChooser();
                    MacFileChooserUI.this.approveButton.setText(MacFileChooserUI.this.getApproveButtonText(jFileChooser));
                    MacFileChooserUI.this.approveButton.setToolTipText(MacFileChooserUI.this.getApproveButtonToolTipText(jFileChooser));
                    MacFileChooserUI.this.approveButton.setMnemonic(MacFileChooserUI.this.getApproveButtonMnemonic(jFileChooser));
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    MacFileChooserUI.this.approveButton.setMnemonic(MacFileChooserUI.this.getApproveButtonMnemonic(MacFileChooserUI.this.getFileChooser()));
                }
            }
        };
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MacFileChooserUI((JFileChooser)jComponent);
    }

    void directoryChanged(File file) {
        this.filechooser.setCurrentDirectory(file);
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        if (this.getModel().contains(file)) {
            this.list.ensureIndexIsVisible(this.getModel().indexOf(file));
        }
    }

    void fileChanged(File file) {
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    public String getDirectoryName() {
        return null;
    }

    public String getFileName() {
        if (this.filechooser.getDialogType() != 0) {
            return this.editField.getText();
        }
        if (this.list.getSelectedValue() != null) {
            return this.list.getSelectedValue().toString();
        }
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return PREF_SIZE;
    }

    void goUpOneDirectory() {
        File file = this.filechooser.getCurrentDirectory();
        if (file.getParent() != null && !file.getParent().equals("/")) {
            FileSystemView fileSystemView = this.filechooser.getFileSystemView();
            File file2 = new File(file.getParent());
            this.filechooser.setCurrentDirectory(file2);
        }
    }

    void initializeComboBox() {
        this.comboBoxModel = new DefaultComboBoxModel();
        File file = this.filechooser.getCurrentDirectory();
        if (file.toString().equals("/")) {
            Thread.dumpStack();
        }
        this.isTemporary = true;
        this.buildParents(file);
        this.isTemporary = false;
        this.comboBox.setModel(this.comboBoxModel);
    }

    void initializeList() {
        File file = this.filechooser.getCurrentDirectory();
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            ++n;
        }
    }

    public void installComponents(JFileChooser jFileChooser) {
        this.filechooser.setLayout(new BorderLayout());
        class WhitePanel
        extends JPanel {
            public WhitePanel() {
            }
        }
        this.leftPanel = new WhitePanel();
        WhitePanel whitePanel = new WhitePanel();
        this.leftPanel.setLayout(new BorderLayout());
        BoxLayout boxLayout = new BoxLayout(whitePanel, 1);
        whitePanel.setLayout(boxLayout);
        this.filechooser.add("Center", this.leftPanel);
        this.filechooser.add("East", whitePanel);
        this.comboBox = new JComboBox();
        this.comboBoxModel = new DefaultComboBoxModel();
        this.comboBox.setModel(this.comboBoxModel);
        this.comboBox.setRenderer(this.createDirectoryComboBoxRenderer(this.filechooser));
        this.comboBox.addActionListener(new DirectoryComboBoxAction());
        WhitePanel whitePanel2 = new WhitePanel();
        whitePanel2.add(this.comboBox);
        this.leftPanel.add("North", whitePanel2);
        this.list = new JList(this.getModel());
        this.list.setCellRenderer(new FileRenderer());
        this.list.addListSelectionListener(this.createListSelectionListener(this.filechooser));
        this.list.addMouseListener(this.createDoubleClickListener(this.filechooser, this.list));
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.leftPanel.add("Center", jScrollPane);
        this.editField = new JTextField();
        this.editPanel = new JPanel();
        if (this.filechooser.getDialogType() != 0) {
            this.addEditField();
        }
        this.volumeLabel = new JLabel("Macintosh HD");
        this.volumeLabel.setHorizontalAlignment(0);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MacFileChooserUI.this.goUpOneDirectory();
            }
        };
        this.volumeLabel.addMouseListener(mouseAdapter);
        whitePanel.add(this.volumeLabel);
        this.ejectButton = new JButton("Eject");
        this.ejectButton.setEnabled(false);
        WhitePanel whitePanel3 = new WhitePanel();
        whitePanel3.add(this.ejectButton);
        whitePanel.add(whitePanel3);
        this.desktopButton = new JButton("Desktop");
        this.desktopButton.setEnabled(false);
        WhitePanel whitePanel4 = new WhitePanel();
        whitePanel4.add(this.desktopButton);
        whitePanel.add(whitePanel4);
        WhitePanel whitePanel5 = new WhitePanel(){
            {
            }

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                int n = MacFileChooserUI.this.desktopButton.getWidth();
                int n2 = this.getWidth();
                int n3 = n2 / 2;
                graphics.setColor(Color.black);
                graphics.drawLine(n3 - n / 2, this.getHeight() / 2, n3 + n / 2, this.getHeight() / 2);
            }
        };
        Dimension dimension = this.desktopButton.getPreferredSize();
        dimension.height /= 2;
        whitePanel5.setPreferredSize(dimension);
        whitePanel.add(whitePanel5);
        this.approveButton = new JButton(this.getApproveButtonText(this.filechooser));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(this.filechooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(this.filechooser));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        WhitePanel whitePanel6 = new WhitePanel();
        whitePanel6.add(this.approveButton);
        whitePanel.add(whitePanel6);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        WhitePanel whitePanel7 = new WhitePanel();
        whitePanel7.add(this.cancelButton);
        whitePanel.add(whitePanel7);
    }

    protected void installIcons(JFileChooser jFileChooser) {
        this.directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        this.fileIcon = UIManager.getIcon("FileView.fileIcon");
        this.computerIcon = UIManager.getIcon("FileView.computerIcon");
        this.hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
        this.floppyDriveIcon = UIManager.getIcon("FileView.floppyDriveIcon");
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString("FileChooser.lookInLabelText");
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString("FileChooser.fileNameLabelText");
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString("FileChooser.filesOfTypeLabelText");
        this.upFolderToolTipText = UIManager.getString("FileChooser.upFolderToolTipText");
        this.upFolderAccessibleName = UIManager.getString("FileChooser.upFolderAccessibleName");
        this.homeFolderToolTipText = UIManager.getString("FileChooser.homeFolderToolTipText");
        this.homeFolderAccessibleName = UIManager.getString("FileChooser.homeFolderAccessibleName");
        this.newFolderToolTipText = UIManager.getString("FileChooser.newFolderToolTipText");
        this.newFolderAccessibleName = UIManager.getString("FileChooser.newFolderAccessibleName");
        this.listViewButtonToolTipText = UIManager.getString("FileChooser.listViewButtonToolTipText");
        this.listViewButtonAccessibleName = UIManager.getString("FileChooser.listViewButtonAccessibleName");
        this.detailsViewButtonToolTipText = UIManager.getString("FileChooser.detailsViewButtonToolTipText");
        this.detailsViewButtonAccessibleName = UIManager.getString("FileChooser.detailsViewButtonAccessibleName");
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBackground(Color.white);
        this.oldFileSystemView = this.filechooser.getFileSystemView();
        this.filechooser.setFileSystemView(new MacFileSystemView());
    }

    void removeEditField() {
        this.leftPanel.remove(this.editField);
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getModel().invalidateFileCache();
        this.getModel().validateFileCache();
    }

    public void setDirectoryName(String string) {
    }

    public void setFileName(String string) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(string);
        }
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterComboBoxModel);
        this.filechooser.setFileSystemView(this.oldFileSystemView);
        super.uninstallUI(jComponent);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        File file = this.getFileChooser().getSelectedFile();
        if (!listSelectionEvent.getValueIsAdjusting() && file != null && !this.getFileChooser().isTraversable(file)) {
            this.setFileName(this.getFileChooser().getName(file));
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            File file = (File)object;
            String string = MacFileChooserUI.this.getFileChooser().getName(file);
            this.setText(string);
            Icon icon = MacFileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            return this;
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        DirectoryComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            File file = (File)object;
            if (file == null) {
                this.setText("");
                return this;
            }
            String string = MacFileChooserUI.this.getFileChooser().getName(file);
            this.setText(string);
            Icon icon = MacFileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            return this;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            FileFilter fileFilter = (FileFilter)object;
            if (fileFilter != null) {
                this.setText(fileFilter.getDescription());
            }
            return this;
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = MacFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return MacFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = MacFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                int n = 0;
                while (n < this.filters.length) {
                    if (this.filters[n] == fileFilter) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    MacFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return MacFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                MacFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MacFileChooserUI.this.getFileChooser().setCurrentDirectory((File)MacFileChooserUI.this.comboBox.getSelectedItem());
        }
    }
}

