/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import anon.util.IResourceInstantiator;
import anon.util.ResourceLoader;
import anon.util.URLDecoder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import logging.LogHolder;
import logging.LogType;

public final class ClassUtil {
    private static final String JAR_FILE = "jar:file:";
    private static final String FILE = "file:";
    private static Hashtable ms_loadedClasses = new Hashtable();
    private static Vector ms_loadedDirectories = new Vector();
    private static boolean ms_bEnableFindSubclasses = true;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$reflect$Method;
    static /* synthetic */ Class class$anon$util$ClassUtil;

    private ClassUtil() {
    }

    public static void addFileToClasspath(String string) throws IOException, IllegalAccessException {
        File file = new File(string);
        ClassUtil.addFileToClasspath(file);
    }

    public static void addFileToClasspath(File file) throws IllegalAccessException {
        URL uRL;
        try {
            uRL = (URL)(class$java$io$File == null ? (class$java$io$File = ClassUtil.class$("java.io.File")) : class$java$io$File).getMethod("toURL", new Class[0]).invoke((Object)file, new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalAccessException(exception.getMessage());
        }
        ClassUtil.addURLToClasspath(uRL);
    }

    public static void addURLToClasspath(URL uRL) throws IllegalAccessException {
        try {
            Object object = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ClassUtil.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getMethod("getSystemClassLoader", new Class[0]).invoke((Object)null, new Object[0]);
            Class<?> clazz = Class.forName("java.net.URLClassLoader");
            Method method = clazz.getDeclaredMethod("addURL", class$java$net$URL == null ? (class$java$net$URL = ClassUtil.class$("java.net.URL")) : class$java$net$URL);
            (class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = ClassUtil.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method).getMethod("setAccessible", Boolean.TYPE).invoke((Object)method, new Boolean(true));
            method.invoke(object, uRL);
        }
        catch (Throwable throwable) {
            throw new IllegalAccessException("Error, could not add URL to system classloader");
        }
    }

    public static String getShortClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    public static Class getClassStatic() {
        return new ClassGetter().getCurrentClassStatic();
    }

    public static String getClassNameStatic() {
        return ClassUtil.getCallingClassStatic().getName();
    }

    public static Class getCallingClassStatic() {
        return new ClassGetter().getCallingClassStatic();
    }

    public static String getUserDir() {
        try {
            return System.getProperty("user.dir");
        }
        catch (SecurityException securityException) {
            return new File(".").toString();
        }
    }

    public static String getClassPath() {
        return ClassUtil.getClassPath(false);
    }

    public static void enableFindSubclasses(boolean bl) {
        ms_bEnableFindSubclasses = bl;
    }

    public static boolean isFindSubclassesEnabled() {
        return ms_bEnableFindSubclasses;
    }

    public static Vector findSubclasses(Class clazz) {
        if (!ms_bEnableFindSubclasses) {
            return new Vector();
        }
        ClassUtil.loadClasses(clazz);
        Enumeration enumeration = ClassUtil.loadClasses(ClassUtil.getCallingClassStatic());
        Vector<Class> vector = new Vector<Class>();
        while (enumeration.hasMoreElements()) {
            Class clazz2 = (Class)enumeration.nextElement();
            if (!clazz.isAssignableFrom(clazz2)) continue;
            vector.addElement(clazz2);
        }
        return vector;
    }

    public static Enumeration loadClasses() {
        Class clazz = ClassUtil.getCallingClassStatic();
        ClassUtil.loadClasses(clazz);
        return ms_loadedClasses.elements();
    }

    public static Enumeration loadClasses(Class clazz) {
        return ClassUtil.loadClasses(clazz, null);
    }

    public static Enumeration loadClasses(File file) {
        return ClassUtil.loadClasses(null, file);
    }

    private static Enumeration loadClasses(Class clazz, File file) {
        block6: {
            PrintStream printStream = new PrintStream(new ByteArrayOutputStream());
            Class clazz2 = ClassUtil.getClassStatic();
            Class clazz3 = ClassUtil.getCallingClassStatic();
            PrintStream printStream2 = System.err;
            try {
                if (file != null) {
                    System.setErr(printStream);
                    ClassUtil.loadClassesInternal(clazz, file);
                    System.setErr(printStream2);
                } else if (clazz != null) {
                    System.setErr(printStream);
                    ClassUtil.loadClassesInternal(clazz, file);
                    System.setErr(printStream2);
                    ClassUtil.loadClassesInternal(clazz2, null);
                    if (clazz3 != clazz && clazz3 != clazz2) {
                        ClassUtil.loadClassesInternal(clazz3, null);
                    }
                }
            }
            catch (Throwable throwable) {
                System.setErr(printStream2);
                if (!(throwable instanceof Exception) || throwable instanceof RuntimeException) break block6;
                throwable.printStackTrace();
            }
        }
        return ms_loadedClasses.elements();
    }

    public static File getClassDirectory(String string) {
        if (string == null) {
            return null;
        }
        try {
            return ClassUtil.getClassDirectory(Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static ZipFile getJarFile() {
        File file = ClassUtil.getClassDirectory(class$anon$util$ClassUtil == null ? (class$anon$util$ClassUtil = ClassUtil.class$("anon.util.ClassUtil")) : class$anon$util$ClassUtil);
        if (file != null && file.getPath().endsWith(".jar")) {
            try {
                return new ZipFile(file);
            }
            catch (IOException iOException) {
                LogHolder.log(3, LogType.MISC, "An I/O error occured while opening the JAR file: ", iOException);
            }
        }
        return null;
    }

    public static File getClassDirectory(Class clazz) {
        File file;
        String string = "/" + ClassUtil.toRelativeResourcePath(clazz);
        URL uRL = clazz.getResource(string);
        if (uRL != null) {
            file = ResourceLoader.getSystemResource(uRL.toString());
        } else {
            LogHolder.log(3, LogType.THREAD, "Get class resource failed!");
            file = null;
        }
        if (file == null) {
            String string2 = URLDecoder.decode(uRL.toString());
            if (string2.startsWith(JAR_FILE)) {
                if ((string2 = string2.substring(JAR_FILE.length(), string2.lastIndexOf(string) - 1)).charAt(2) == ':') {
                    string2 = string2.substring(1, string2.length());
                }
                string2 = ResourceLoader.replaceFileSeparatorsSystemSpecific(string2);
                file = new File(string2);
            } else if (string2.startsWith(FILE)) {
                string2 = string2.substring(FILE.length(), string2.lastIndexOf(string));
                file = new File(string2);
            } else {
                file = null;
            }
            if (file == null || !file.exists()) {
                return null;
            }
        }
        return file;
    }

    public static String toRelativeResourcePath(Class clazz) {
        String string = clazz.getName();
        string = string.replace('.', '/');
        string = string + ".class";
        return string;
    }

    public static Class getFirstClassFound(File file) {
        Hashtable hashtable = new Hashtable();
        ResourceLoader.loadResources("/", file, new ClassInstantiator(3), true, true, hashtable);
        if (hashtable.size() == 1) {
            return (Class)hashtable.elements().nextElement();
        }
        return null;
    }

    protected static String getClassPath(boolean bl) {
        String string = "";
        if (!bl) {
            try {
                string = ClassUtil.getClassDirectory(class$anon$util$ClassUtil == null ? (class$anon$util$ClassUtil = ClassUtil.class$("anon.util.ClassUtil")) : class$anon$util$ClassUtil).toString() + File.pathSeparator;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return string + System.getProperty("java.class.path");
        }
        catch (SecurityException securityException) {
            return string;
        }
    }

    private static void loadClassesInternal(Class clazz, File file) throws IOException {
        File file2;
        if (file != null) {
            file2 = file;
        } else if (clazz == null || clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.") || (file2 = ClassUtil.getClassDirectory(clazz)) == null) {
            return;
        }
        if (ms_loadedDirectories.contains(file2.getAbsolutePath())) {
            return;
        }
        ms_loadedDirectories.addElement(file2.getAbsolutePath());
        ResourceLoader.loadResources("/", file2, new ClassInstantiator(), true, false, ms_loadedClasses);
    }

    private static Class toClass(File file, File file2) {
        Class<?> clazz;
        String string;
        if (file == null || !file.getName().endsWith(".class")) {
            return null;
        }
        int n = file2 == null || !file2.isDirectory() ? 0 : ((string = file2.toString()).endsWith(System.getProperty("file.separator")) ? string.length() : string.length() + 1);
        try {
            String string2 = file.toString();
            string2 = string2.substring(n, string2.lastIndexOf(".class"));
            string2 = string2.replace(File.separatorChar, '.');
            clazz = Class.forName(string2);
        }
        catch (Throwable throwable) {
            clazz = null;
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ClassInstantiator
    implements IResourceInstantiator {
        private int m_invalidAfterFailure;
        private int m_currentFailure;

        public ClassInstantiator() {
            this.m_invalidAfterFailure = 0;
            this.m_currentFailure = 0;
        }

        public ClassInstantiator(int n) {
            this.m_invalidAfterFailure = n;
            this.m_currentFailure = 0;
        }

        public Object getInstance(File file, File file2) throws IResourceInstantiator.ResourceInstantiationException {
            Class clazz = ClassUtil.toClass(file, file2);
            if (this.m_invalidAfterFailure > 0) {
                this.checkValidity(clazz, file.getName());
            }
            return clazz;
        }

        public Object getInstance(ZipEntry zipEntry, ZipFile zipFile) throws IResourceInstantiator.ResourceInstantiationException {
            Class clazz = ClassUtil.toClass(new File(zipEntry.toString()), null);
            if (this.m_invalidAfterFailure > 0) {
                this.checkValidity(clazz, zipEntry.getName());
            }
            return clazz;
        }

        private void checkValidity(Class clazz, String string) throws IResourceInstantiator.ResourceInstantiationException {
            if (clazz == null && string.endsWith(".class")) {
                ++this.m_currentFailure;
            }
            if (this.m_currentFailure >= this.m_invalidAfterFailure) {
                throw new IResourceInstantiator.ResourceInstantiationException();
            }
        }

        public Object getInstance(InputStream inputStream, String string) {
            return null;
        }
    }

    private static class ClassGetter
    extends SecurityManager {
        private ClassGetter() {
        }

        public Class getCurrentClassStatic() {
            return this.getClassContext()[2];
        }

        public Class getCallingClassStatic() {
            return this.getClassContext()[3];
        }
    }

    public static final class Package {
        private String m_strPackage;

        public Package(Class clazz) {
            this.m_strPackage = clazz == null || clazz.getName().indexOf(".") < 0 ? "" : clazz.getName().substring(0, clazz.getName().lastIndexOf("."));
        }

        public Package(String string) {
            if (this.m_strPackage == null || this.m_strPackage.trim().length() == 0) {
                this.m_strPackage = "";
            } else {
                if (new StringTokenizer(this.m_strPackage).countTokens() > 1) {
                    throw new IllegalArgumentException("Package names may not contain whitespaces!");
                }
                for (int i = 0; i < this.m_strPackage.length(); ++i) {
                    if (Character.isLetterOrDigit(this.m_strPackage.charAt(i)) || this.m_strPackage.charAt(i) == '.') continue;
                    if (this.m_strPackage.charAt(i) == '\\' && this.m_strPackage.length() > i + 5 && this.m_strPackage.charAt(i + 1) == 'u') {
                        boolean bl = true;
                        for (int j = i + 2; j < i + 5; ++j) {
                            if (Character.isDigit(this.m_strPackage.charAt(j))) continue;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            i += 5;
                            continue;
                        }
                    }
                    throw new IllegalArgumentException("Illegal character in package name: " + this.m_strPackage.charAt(i));
                }
                this.m_strPackage = string;
            }
        }

        public String getPackage() {
            return this.m_strPackage;
        }
    }
}

