/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Codecs;
import HTTPClient.GlobalConstants;
import HTTPClient.HashVerifier;
import HTTPClient.RoResponse;
import HTTPClient.Util;
import java.io.IOException;

class VerifyMD5
implements HashVerifier,
GlobalConstants {
    RoResponse resp;

    public VerifyMD5(RoResponse resp) {
        this.resp = resp;
    }

    public void verifyHash(byte[] hash2, long len) throws IOException {
        String hdr;
        try {
            hdr = this.resp.getHeader("Content-MD5");
            if (hdr == null) {
                hdr = this.resp.getTrailer("Content-MD5");
            }
        }
        catch (IOException ioe) {
            return;
        }
        if (hdr == null) {
            return;
        }
        hdr = hdr.trim();
        byte[] ContMD5 = hdr.getBytes();
        ContMD5 = Codecs.base64Decode(ContMD5);
        int idx = 0;
        while (idx < hash2.length) {
            if (hash2[idx] != ContMD5[idx]) {
                throw new IOException("MD5-Digest mismatch: expected " + VerifyMD5.hex(ContMD5) + " but calculated " + VerifyMD5.hex(hash2));
            }
            ++idx;
        }
        if (GlobalConstants.DebugMods) {
            Util.logLine("CMD5M: hash successfully verified");
        }
    }

    private static String hex(byte[] buf) {
        StringBuffer str = new StringBuffer(buf.length * 3);
        int idx = 0;
        while (idx < buf.length) {
            str.append(Character.forDigit(buf[idx] >>> 4 & 0xF, 16));
            str.append(Character.forDigit(buf[idx] & 0xF, 16));
            str.append(':');
            ++idx;
        }
        str.setLength(str.length() - 1);
        return str.toString();
    }
}

