/*
 * Decompiled with CFR 0.152.
 */
package anon.transport.connection;

import anon.transport.address.IAddress;
import anon.transport.address.SkypeAddress;
import anon.transport.connection.ConnectionException;
import anon.transport.connection.IChunkConnection;
import anon.transport.connection.IChunkReader;
import anon.transport.connection.IChunkWriter;
import anon.transport.connection.UnsuportedCommandException;
import anon.transport.connection.util.QueuedChunkReader;
import anon.util.Base64;
import anon.util.ObjectQueue;
import com.skype.Application;
import com.skype.ApplicationListener;
import com.skype.SkypeException;
import com.skype.Stream;
import com.skype.StreamListener;
import java.io.IOException;
import logging.LogHolder;
import logging.LogType;

public class SkypeConnection
implements IChunkConnection {
    public static final int IDLE_TIME_OUT = 480000;
    private final SkypeReader m_reader;
    private final SkypeWriter m_writer;
    private final SkypeAddress m_localAddress;
    private final SkypeAddress m_remoteAddress;
    private final Application m_application;
    private final Stream m_appStream;
    private int m_state;
    private ApplicationListener m_listner;

    public SkypeConnection(Stream a_appStream) {
        if (a_appStream == null) {
            throw new NullPointerException("No Application Stream provided");
        }
        this.m_appStream = a_appStream;
        this.m_reader = new SkypeReader(this.m_appStream);
        this.m_writer = new SkypeWriter(this.m_appStream);
        this.m_application = this.m_appStream.getApplication();
        String appName = this.m_application.getName();
        String remoteUserID = this.m_appStream.getFriend().getId();
        String localUserID = "<unresolved>";
        LogHolder.log(7, LogType.TRANSPORT, "Try to connect to " + remoteUserID + " from " + localUserID);
        this.m_localAddress = new SkypeAddress(localUserID, appName);
        this.m_remoteAddress = new SkypeAddress(remoteUserID, appName);
        this.m_state = 1;
        this.m_listner = new ApplicationListener(){

            public void connected(Stream arg0) throws SkypeException {
            }

            public void disconnected(Stream a_disconnectingStream) throws SkypeException {
                if (a_disconnectingStream.getId().equals(SkypeConnection.this.m_appStream.getId())) {
                    try {
                        SkypeConnection.this.close(false);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        this.m_application.addApplicationListener(this.m_listner);
    }

    public IChunkReader getChunkReader() {
        return this.m_reader;
    }

    public IChunkWriter getChunkWriter() {
        return this.m_writer;
    }

    public int getCurrentState() {
        return this.m_state;
    }

    public IAddress getLocalAddress() {
        return this.m_localAddress;
    }

    public IAddress getRemoteAddress() {
        return this.m_remoteAddress;
    }

    public int getTimeout() throws ConnectionException {
        return 0;
    }

    public void setTimeout(int value) throws ConnectionException {
        throw new UnsuportedCommandException("Timeout could not be changed for Connection of Skype");
    }

    public void close(boolean a_disconnectStream) throws IOException {
        if (this.m_state != 2) {
            this.m_state = 2;
            this.m_application.removeApplicationListener(this.m_listner);
            this.m_reader.tearDown();
            this.m_writer.close();
            try {
                if (a_disconnectStream) {
                    this.m_appStream.disconnect();
                }
            }
            catch (SkypeException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public void close() throws IOException {
        this.close(true);
    }

    private static class SkypeWriter
    implements IChunkWriter {
        private Stream m_appStream;
        private boolean m_isClosed;

        public SkypeWriter(Stream a_appStream) {
            this.m_appStream = a_appStream;
            this.m_isClosed = false;
        }

        public void writeChunk(byte[] a_chunk) throws ConnectionException {
            if (!this.m_isClosed) {
                String message = Base64.encode(a_chunk, false);
                try {
                    this.m_appStream.write(message);
                }
                catch (SkypeException e) {
                    throw new ConnectionException(e);
                }
            }
        }

        public void close() throws IOException {
            this.m_isClosed = true;
        }
    }

    private static class SkypeReader
    implements IChunkReader {
        public static final int MAX_MESSAGE_LENGTH = 65535;
        private ObjectQueue m_readBuffer;
        private Stream m_appStream;
        private StreamListener m_listner;
        private QueuedChunkReader m_baseReader;

        public SkypeReader(Stream a_appStream) {
            this.m_appStream = a_appStream;
            this.m_readBuffer = new ObjectQueue();
            this.m_baseReader = new QueuedChunkReader(this.m_readBuffer);
            this.m_listner = new StreamListener(){

                public void textReceived(String aa_message) throws SkypeException {
                    byte[] packet = Base64.decode(aa_message);
                    if (packet != null && packet.length > 0) {
                        LogHolder.log(7, LogType.TRANSPORT, "Receveid text, push in the queue");
                        SkypeReader.this.m_readBuffer.push(packet);
                    }
                }

                public void datagramReceived(String arg0) throws SkypeException {
                    LogHolder.log(4, LogType.TRANSPORT, "Received Datagram from Skype, but we only expect Streams.");
                }
            };
            this.m_appStream.addStreamListener(this.m_listner);
        }

        public int availableChunks() throws ConnectionException {
            return this.m_baseReader.availableChunks();
        }

        public byte[] readChunk() throws ConnectionException {
            byte[] result = this.m_baseReader.readChunk();
            return result;
        }

        public void close() throws IOException {
            this.m_appStream.removeStreamListener(this.m_listner);
            this.m_baseReader.close();
        }

        public void tearDown() throws IOException {
            this.m_appStream.removeStreamListener(this.m_listner);
            this.m_baseReader.tearDown();
        }
    }
}

