/*
 * Decompiled with CFR 0.152.
 */
package anon.platform;

import anon.platform.AbstractOS;
import anon.util.ClassUtil;
import anon.util.RecursiveFileTool;
import anon.util.Util;
import anon.util.ZipArchiver;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.ZipFile;
import logging.LogHolder;
import logging.LogType;

public final class MacOS
extends AbstractOS {
    public static final String OS_NAME = "Mac OS";
    static final String BUNDLE_CONTENTS;
    static final String BUNDLE_RESOURCES;
    static final String BUNDLE_MAC_OS_EXECUTABLES;
    static final String BUNDLE_PROPERTY_FILE_NAME = "Info.plist";
    static final String BUNDLE_EXECUTABLE_PROPERTY_KEY = "CFBundleExecutable";
    static final String ROOT_SHELLSCRIPT_NAME = "rootShellScript";
    static final String OSA_EXEC_SHELLSCRIPT_STMT = "do shell script rootShellScript with administrator privileges";
    static final String OSA_APPLET_NAME = "JonDoUpdater.app";
    static final String OSA_APPLET_PATH;
    static final String[] OSASCRIPT_CMD;
    static final String[] OSACOMPILE_CMD;
    static final String[] OPEN_UPDATER_CMD;
    private static final String MACOS_VBOX_NETADAPTER = "vboxnet";
    private String m_bundlePath = null;

    public MacOS() throws Exception {
        if (System.getProperty("mrj.version") == null) {
            throw new Exception("Operating system is not Mac OS");
        }
        this.setBundlePath();
    }

    protected boolean openLink(String a_link) {
        return this.execute("open " + Util.encodeWhiteSpaces(a_link));
    }

    public String getAppdataDefaultDirectory(String a_applicationName, boolean a_bCreate) {
        return null;
    }

    public boolean isHelpAutoInstalled() {
        return true;
    }

    public String getConfigPath(String a_applicationName, boolean a_bCreate) {
        if (System.getProperty("os.name").equalsIgnoreCase(OS_NAME)) {
            return System.getProperty("user.home", ".") + "/";
        }
        return System.getProperty("user.home", "") + "/Library/Preferences/";
    }

    public void setBundlePath() {
        String path;
        File classParentFile = ClassUtil.getClassDirectory(this.getClass());
        if (classParentFile != null && (path = classParentFile.getPath()) != null) {
            int index_path;
            if (!path.startsWith(File.separator)) {
                int s_index = path.indexOf("/");
                String string = path = s_index != -1 ? path.substring(s_index) : path;
            }
            if ((index_path = path.indexOf(BUNDLE_CONTENTS)) != -1) {
                this.m_bundlePath = path.substring(0, index_path - 1);
                return;
            }
        }
        this.m_bundlePath = null;
    }

    public String getBundlePath() {
        return this.m_bundlePath;
    }

    public boolean isBundle() {
        return this.m_bundlePath != null;
    }

    public String getBundleExecutablePath() {
        return null;
    }

    private static int handleAppleScriptCmds(String[] statements, Process handler) throws IOException, InterruptedException {
        PrintWriter stdinWriter = new PrintWriter(handler.getOutputStream());
        for (int i = 0; i < statements.length; ++i) {
            stdinWriter.println(statements[i]);
        }
        stdinWriter.flush();
        stdinWriter.close();
        return handler.waitFor();
    }

    public boolean isVirtualBoxInterface(Object a_networkInterface) {
        String strDisplayName = AbstractOS.getInterfaceName(a_networkInterface);
        return strDisplayName != null && strDisplayName.indexOf(MACOS_VBOX_NETADAPTER) >= 0;
    }

    public boolean copyAsRoot(File src, File destDir, AbstractOS.AbstractRetryCopyProcess a_checkRetry) {
        String osaShellscript_stmt = "set rootShellScript to \"cp " + src.getAbsolutePath() + " " + destDir.getAbsolutePath() + "\"";
        String[] allStmts = new String[]{osaShellscript_stmt, OSA_EXEC_SHELLSCRIPT_STMT};
        try {
            File appletFile;
            Runtime runtime = Runtime.getRuntime();
            int exitValue = 1;
            if (OSACOMPILE_CMD != null) {
                Process osaCompiler = runtime.exec(OSACOMPILE_CMD);
                exitValue = MacOS.handleAppleScriptCmds(allStmts, osaCompiler);
            }
            if (exitValue == 0) {
                ZipFile japArchive = ClassUtil.getJarFile();
                if (japArchive != null) {
                    ZipArchiver archiver = new ZipArchiver(japArchive);
                    File oldImage = new File(OSA_APPLET_PATH + File.separator + BUNDLE_RESOURCES + "applet.icns");
                    oldImage.delete();
                    archiver.extractSingleEntry("images/JUpdate.icns", OSA_APPLET_PATH + File.separator + BUNDLE_RESOURCES + "applet.icns");
                }
                Process execCopy = runtime.exec(OPEN_UPDATER_CMD);
                exitValue = execCopy.waitFor();
            } else {
                Process osaInterpreter = runtime.exec(OSASCRIPT_CMD);
                exitValue = MacOS.handleAppleScriptCmds(allStmts, osaInterpreter);
            }
            if (OSA_APPLET_PATH != null && (appletFile = new File(OSA_APPLET_PATH)).exists() && OSA_APPLET_PATH.endsWith(OSA_APPLET_NAME)) {
                RecursiveFileTool.deleteRecursion(appletFile);
            }
            return RecursiveFileTool.equals(src, new File(destDir.getAbsolutePath() + File.separator + src.getName()), true);
        }
        catch (IOException ioe) {
            LogHolder.log(6, LogType.MISC, "Mac OS root copy failed: ", ioe);
            return false;
        }
        catch (InterruptedException ie) {
            LogHolder.log(2, LogType.MISC, "Interrupted while waiting for root copy process ", ie);
            return false;
        }
    }

    static {
        String[] stringArray;
        String[] stringArray2;
        BUNDLE_CONTENTS = "Contents" + File.separator;
        BUNDLE_RESOURCES = BUNDLE_CONTENTS + "Resources" + File.separator;
        BUNDLE_MAC_OS_EXECUTABLES = BUNDLE_CONTENTS + "MacOS" + File.separator;
        OSA_APPLET_PATH = AbstractOS.getDefaultTempPath() != null ? AbstractOS.getDefaultTempPath() + OSA_APPLET_NAME : null;
        OSASCRIPT_CMD = new String[]{"osascript"};
        if (OSA_APPLET_PATH != null) {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "osacompile";
            stringArray3[1] = "-xo";
            stringArray2 = stringArray3;
            stringArray3[2] = OSA_APPLET_PATH;
        } else {
            stringArray2 = OSACOMPILE_CMD = null;
        }
        if (OSA_APPLET_PATH != null) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = OSA_APPLET_PATH + File.separator + BUNDLE_MAC_OS_EXECUTABLES + "applet";
        } else {
            stringArray = null;
        }
        OPEN_UPDATER_CMD = stringArray;
    }
}

