/*
 * Decompiled with CFR 0.152.
 */
package anon.forward.server;

import anon.forward.server.ForwardCascadeDatabase;
import anon.forward.server.ForwardScheduler;
import anon.forward.server.ForwardSchedulerStatistics;
import anon.forward.server.IServerManager;
import anon.forward.server.ServerSocketManager;
import logging.LogHolder;
import logging.LogType;

public class ForwardServerManager {
    public static final int CLIENT_CONNECTION_TIMEOUT = 200000;
    public static final int CLIENT_DUMMYTRAFFIC_INTERVAL = 180000;
    private static ForwardServerManager ms_fsmInstance = null;
    private int m_dummyTrafficInterval = -1;
    private ForwardCascadeDatabase m_allowedCascadesDatabase = new ForwardCascadeDatabase();
    private ForwardScheduler m_forwardScheduler = null;

    public static ForwardServerManager getInstance() {
        if (ms_fsmInstance == null) {
            ms_fsmInstance = new ForwardServerManager();
        }
        return ms_fsmInstance;
    }

    private ForwardServerManager() {
    }

    public void setDummyTrafficInterval(int a_interval) {
        this.m_dummyTrafficInterval = a_interval >= 0 ? Math.min(a_interval, 180000) : 180000;
    }

    public int getDummyTrafficInterval() {
        return this.m_dummyTrafficInterval;
    }

    public ForwardCascadeDatabase getAllowedCascadesDatabase() {
        return this.m_allowedCascadesDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumNumberOfConnections(int a_maxNumberOfConnections) {
        ForwardServerManager forwardServerManager = this;
        synchronized (forwardServerManager) {
            if (this.m_forwardScheduler != null) {
                this.m_forwardScheduler.setMaximumNumberOfConnections(a_maxNumberOfConnections);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetBandwidth(int a_netBandwidth) {
        ForwardServerManager forwardServerManager = this;
        synchronized (forwardServerManager) {
            if (this.m_forwardScheduler != null) {
                this.m_forwardScheduler.setNetBandwidth(a_netBandwidth);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addListenSocket(int a_portNumber) {
        Object serverManagerId = null;
        ForwardServerManager forwardServerManager = this;
        synchronized (forwardServerManager) {
            if (this.m_forwardScheduler != null) {
                ServerSocketManager serverSocketManager = new ServerSocketManager(a_portNumber);
                try {
                    this.m_forwardScheduler.addServerManager(serverSocketManager);
                    serverManagerId = serverSocketManager.getId();
                    LogHolder.log(7, LogType.NET, "Establishing ServerManager with ID '" + serverManagerId.toString() + "' was successful.");
                }
                catch (Exception e) {
                    LogHolder.log(2, LogType.NET, "Error establishing socket at port " + Integer.toString(a_portNumber) + ". Reason: " + e.toString());
                }
            }
        }
        return serverManagerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addServerManager(IServerManager a_manager) {
        Object serverManagerId = null;
        ForwardServerManager forwardServerManager = this;
        synchronized (forwardServerManager) {
            if (this.m_forwardScheduler != null) {
                try {
                    this.m_forwardScheduler.addServerManager(a_manager);
                    serverManagerId = a_manager.getId();
                    LogHolder.log(7, LogType.NET, "Establishing ServerManager with ID '" + serverManagerId.toString() + "' was successful.");
                }
                catch (Exception e) {
                    LogHolder.log(2, LogType.NET, "Error adding Servermanager of Type " + a_manager.getClass().getName() + ". Reason: " + e.toString());
                }
            }
        }
        return serverManagerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerManager(Object a_serverManagerId) {
        if (a_serverManagerId != null) {
            ForwardServerManager forwardServerManager = this;
            synchronized (forwardServerManager) {
                if (this.m_forwardScheduler != null) {
                    this.m_forwardScheduler.removeServerManager(a_serverManagerId);
                    LogHolder.log(7, LogType.NET, "ForwardServerManager: removeServerManager: ServerManager with ID '" + a_serverManagerId.toString() + "' was removed (if it was running).");
                }
            }
        } else {
            LogHolder.log(2, LogType.NET, "ForwardServerManager: removeServerManager: ServerManager ID null is invalid.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllServerManagers() {
        ForwardServerManager forwardServerManager = this;
        synchronized (forwardServerManager) {
            if (this.m_forwardScheduler != null) {
                this.m_forwardScheduler.removeAllServerManagers();
                LogHolder.log(7, LogType.NET, "ForwardServerManager: removeAllServerManagers: All server managers removed.");
            }
        }
    }

    public boolean isRunning() {
        return this.m_forwardScheduler != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownForwarding() {
        ForwardServerManager forwardServerManager = this;
        synchronized (forwardServerManager) {
            if (this.m_forwardScheduler != null) {
                this.m_forwardScheduler.shutdown();
                this.m_forwardScheduler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startForwarding() {
        ForwardServerManager forwardServerManager = this;
        synchronized (forwardServerManager) {
            if (this.m_forwardScheduler == null) {
                this.m_forwardScheduler = new ForwardScheduler();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForwardSchedulerStatistics getSchedulerStatistics() {
        ForwardSchedulerStatistics schedulerStatistics = null;
        ForwardServerManager forwardServerManager = this;
        synchronized (forwardServerManager) {
            if (this.m_forwardScheduler != null) {
                schedulerStatistics = this.m_forwardScheduler.getStatistics();
            }
        }
        return schedulerStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentlyForwardedConnections() {
        int forwardedConnections = 0;
        ForwardServerManager forwardServerManager = this;
        synchronized (forwardServerManager) {
            if (this.m_forwardScheduler != null) {
                forwardedConnections = this.m_forwardScheduler.getCurrentlyForwardedConnections();
            }
        }
        return forwardedConnections;
    }
}

